/**
 ** Sitemap generator for RoboHelp.
 **
 ** Copyright 2013-2014 - Willam van Weelden
 **/

/* Include library. */
/**
 **
 **	Willam van Weelden Extendscript library loader
 **
 ** Include this file to load the library
 **
 **
 **/

/* Include dependant files */
Array.prototype.max = function() {
	return array_max(this);
};
Array.prototype.min = function(){
	return array_min(this);
};
Array.prototype.remove = function(from, to) {
	return array_remove(this, from, to);
}
Array.prototype.toLowerCase = function() {
	return array_toLowerCase(this);
}
function array_key_exists (key, search) {
  // http://kevin.vanzonneveld.net
  // +   original by: Kevin van Zonneveld (http://kevin.vanzonneveld.net)
  // +   improved by: Felix Geisendoerfer (http://www.debuggable.com/felix)
  // *     example 1: array_key_exists('kevin', {'kevin': 'van Zonneveld'});
  // *     returns 1: true
  // input sanitation
  if (!search || (search.constructor !== Array && search.constructor !== Object)) {
    return false;
  }

  return key in search;
}
function array_max(array) {
	/*
		Array min - By John Resig
	*/
	return Math.max.apply( Math, array );
}
function array_min(array) {
	/*
		Array min - By John Resig
	*/
    return Math.min.apply( Math, array );
}
function array_toLowerCase(array) {
	var lowercasearray = new Array();
	for(var i = 0; i<array.length; i++) {
	   if(typeof(array[i]) == "string") {
		   lowercasearray.push(array[i].toLowerCase());
		} else {
			lowercasearray.push(array[i]);
		}
	}
	return lowercasearray;
}
function array_remove(array, from, to) {
	/*
		Array Remove - By John Resig (MIT Licensed)
		http://ejohn.org/blog/javascript-array-remove/
	*/
	var rest = array.slice((to || from) + 1 || array.length);
	array.length = from < 0 ? array.length + from : from;
	return array.push.apply(array, rest);
}
function in_array (needle, haystack, strict) {
	
	if(is_array(needle)) {
		alert("in_array expects first parameter to be a string. Array given.");
		return false;
	} else if(!is_array(haystack)) {
		alert("in_array expects second parameter to be an array.")
		return false;
	}
	
	if(!strict) {
		strict = false;
	}
		
	var inarray = false;
	for(var i = 0; i<haystack.length; i++)
	{	
		if(strict)
		{
			if(needle === haystack[i])
			{
				inarray = true;
				break;
			}
		}
		else
		{
			if(needle == haystack[i])
			{
				inarray = true;
				break;
			}
		}
	}
	return inarray;
}
function is_array(object) {
	if(!isValidType(object))
		return false;
	else if(object.constructor.toString().indexOf("Array") == -1)
		return false;
	else
		return true;
}
function ExecuteBatchFile(command, waitforbatch) {
                
	if(string_isEmpty(command))
		return false;

	if(!waitforbatch) {
		if(waitforbatch != false) {
			waitforbatch = true;
		}
	}
	
	var path = Folder.appData.fsName + '/';

	var batFileName = 'ExtendScriptBatchFile';
	var batFileExtension = '.bat';
	var batFile = new File(path+batFileName+batFileExtension);
	if(batFile.exists) {
		var i  = 0;
		while(batFile.exists) {
			i++;
			batFile = new File(path+batFileName+i+batFileExtension);
		}
	}

	command+= "\ndel /F /Q \"" + batFile.fsName + "\"";

	writeFile(batFile, command, false);
	if(!isFile(batFile, true))
		return false;

	batFile.execute();

	/*Wait on batch file execution if needed*/
	if(waitforbatch) {
		while(batFile.exists) {
			msg(".");
			$.sleep(100);
		}
	}
	return true;
}

function openURL(url) {
	ExecuteBatchFile("start "+url+"  \n", false);
}
function getNextMapNumber() {
	if(RHInit == false) {/* RoboHelp must be available before this can be called. */
		return null;
	}

	/*Assume that the map numbers are simple incremented numbers*/
	var lowestnumber = 1;
	var highestnumber = 4294967295;

	if(MapNumbers.length == 0) {
		var nextnumber = lowestnumber;
	} else if(!CSHHighestNumberTaken) {/*The hightest number has not yet been taken, or is not know to be taken yet.*/
		var nextnumber = array_max(MapNumbers) + 1;
	} else {
		var nextnumber = highestnumber+1;/*Take the highest number so the search loop will start.*/
	}

	if(nextnumber > highestnumber) {
		CSHHighestNumberTaken = true;/*The highest number has been taken. No need to use the .max() method next time this function is called. Saves time.*/
		if(!CSHNoMoreMapNumbers) {/*By default, there are mapnumbers.*/
			if(CSHLastAssignedNumber == false) {/*Check to see if the function already assigned a MapNumber before. No need to start counting at 1 when there is a higher number.*/
				nextnumber = lowestnumber;
			} else {
				nextnumber = CSHLastAssignedNumber+1;
			}

			/*The highest number has been taken. Determine if there is another number we can use.*/
			while(in_array(nextnumber, MapNumbers)) {
				nextnumber++;
			}

			if(nextnumber > highestnumber) {
				nextnumber = null;
				CSHNoMoreMapNumbers = true;/*There are no more mapnumbers available. No need to loop the set numbers anymore when this function is called again. Saves time.*/
			}
		} else {
			nextnumber = null;
		}
	}
	if(nextnumber == null) {
		alert("There are no more MapId's available in this project.");
	}

	CSHLastAssignedNumber = nextnumber;

	return nextnumber;
}

function unloadCSH() {
	/*
		Reset CSH to false to allow the script to check if the CSH is already initialized.
		Called by unloadcurrentproject();
	*/
	CSH = false;
	MapNumbers = new Array();
	TopicIds = new Array();
}
function loadCSH() {
	/*
		This function loads all the CSH (MapId's, TopicId's and Topic references) into the array CSH.
		Done for easy searching so you don't have to parse all CSH file every time you need this info.
	*/
	
	msg("\nLoading all the project's Context Sensitivity\n");
	
	var aliasfile = "";
	var mapfiles = new Array();
	
	CSH = new Array();
	MapNumbers = new Array();
	TopicIds = new Array();
	
	var CSHtmpArray = new Array();
	
	for(var i = 1; i<=currentProject.FileManager.count; i++) {
		
		var file = currentProject.FileManager.item(i);
		if(file.extension == aliasfileextension) {
			aliasfile = new File(file.path);
		} else if(in_array(file.extension, mapfileextension)) {
			mapfiles.push(new File(file.path));
		}
	}
	
	/* Load all project topicid's and map# */
	for(var i = 0; i<mapfiles.length; i++) {
		var mapfile = mapfiles[i];
		var mapfilecontent = readFile(mapfile).split("\n");
		
		for(var j = 0; j<mapfilecontent.length;j++)
		{
			var line = mapfilecontent[j];
			/*Skip empty lines*/
			if(trim(line) != "") {
				
				/*Both Map# and TopicId are mandatory. So no need to check that both exist*/
				line = line.replace("#define ", "");
				
				/*Separator can be a tab or a space*/
				if(line.match("\t")) {
					line = line.split("\t");
				} else {
					line = line.split(" ");
				}
				
				var thislinearray = new Array();
				/*Load topicid's*/
				thislinearray[CSHTopicidKey] = line[0];
				TopicIds.push(line[0]);
				/*Load map#*/
				thislinearray[CSHMapnumberKey] = parseFloat(line[1]);
				MapNumbers.push(line[1]);
				CSHtmpArray.push(thislinearray);
			}
		}
	}
	
	/*Now get all aliasses and combine the topicid's/Map# with the correct topics*/
	var AliasXML = new XML(readFile(aliasfile));
	var Aliasses = AliasXML.children();
	for(var i = 0; i<Aliasses.length(); i++) {
		var alias = Aliasses[i];
		
		/*The alias file only contains links between topicid and topic. CSH without assigned topic are not in this file.*/
		var topicid = alias.attribute("name").toString();
		var topic = alias.attribute("link").toString().toLowerCase().replace(/\\/g,"/");
		for(var j = 0; j<CSHtmpArray.length; j++) {
			if(CSHtmpArray[j][CSHTopicidKey] == topicid) {
				CSHtmpArray[j][CSHTopicKey] = topic;
				CSH.push(CSHtmpArray[j]);
				array_remove(CSHtmpArray, j);
				break;
			}
			
		}
		
	}
	/*
		Elements still in the array are elements without a topic assigned. These elements need to be pushed to the CSH array too.
	*/
	for(var i = 0; i<CSHtmpArray.length; i++) {
		CSHtmpArray[i][CSHTopicKey] = false;/*No topic available*/
		CSH.push(CSHtmpArray[i]);
	}
	msg("Finished loading Context Sensitivity\n");
}
/*
	For File.convertUTF8, see utf8.jsxinc
	For File.zip(), see zip.jsxinc
*/
File.prototype.content = function(content, encoding) {
	return file_content(this, content, encoding);
}
File.prototype.extension = function() {
    return extension(this.fsName);
}
File.prototype.folder = function() {
    return folder(this.fsName);
}
File.prototype.readFile = function (encoding) {
	return readFile(this, encoding);
}
File.prototype.writeFile = function (szOutput, encoding) {
	return writeFile(this, szOutput, encoding);
}
function file_content(file, content, encoding) {
	if(!content) {
	   content = false;
	}

	if(!encoding || encoding == true) {
	   encoding = "UTF-8";
	}
			   
	if(!content) {
	   return readFile(file, encoding);
	} else {
	   writeFile(file, content, encoding);
	   return true;
	}
}
function readFile(file, encoding) {
	var thisfile = file;
	var szFilePath = thisfile.fsName;
	
	if(!isFile(thisfile)) {
	   return null;
	}
	
	if(!encoding || encoding == true) {
	   encoding == "UTF-8";
	}

	var szRetVal = "";
	var fileObj = new File(szFilePath);
	fileObj.encoding = encoding;
	fileObj.open("r");
	while (!fileObj.eof) {
	   szRetVal += fileObj.readln()+"\n";
	}
	fileObj.close();
	return szRetVal;
}
function writeFile(file, szOutput, encoding) {
	var szFilePath = file.fsName;
	
	if(!encoding || encoding == true) {
	   encoding = "UTF-8";
	}
	
	var fileObj = new File(szFilePath);
	fileObj.encoding = encoding;
	fileObj.open("w");
	fileObj.write(szOutput);
	fileObj.close();
}
function extension(filename) {
	var ext = "";/*If no extension, return an empty string.*/
	var index = filename.lastIndexOf(".");
	if(index != -1) {
		ext = filename.substr(index, filename.length - index).toLowerCase();
	}
	return ext;
}
function filename(absolutepath) {/*Returns filename from absolute path.*/
	absolutepath = absolutepath.replace(/\\/g, "/");
	return absolutepath.substring(absolutepath.lastIndexOf("/")+1);
}
function FilePathExists(absolutepath) {
	var file = new File(absolutepath);
	return isFile(file, true);
}
function folder(absolutepath) {/*Returns path from absolute path to file*/
	absolutepath = absolutepath.replace(/\\/g,"/");
	return absolutepath.substring(0,absolutepath.lastIndexOf("/"));
}
function isValidFilePath(path, filename) {
	if(!isValidType(path)) {
        return false;
	} else if(is_array(path)) {
		return false;
	}
    
    var bRetVal = !string_isEmpty(path) && FilePathExists(path);
    if (bRetVal) {
        bRetVal = false;
        path = path.toLowerCase();
        if (path.length > filename.length) {
            path = path.substr(path.length - filename.length);
            if (path == filename) {
                bRetVal = true;
            }
        }
    }
    return bRetVal;
}
function isFile(file, mustexist) {/*Check whether an object is a file object and optionally whether the file exists on the file system.*/
	if(!mustexist) {
		mustexist = false;
	}
	
	var isfile = false;
	if(file instanceof File)
	{
		isfile = true;
		
		if(mustexist) {
			if(!file.exists) {
				isfile = false;
			}
		}
	}
	return isfile;
}
/*
	For Folder.zip(), see zip.jsxinc
*/
Folder.prototype.copy = function(tarFolder) {
    copyFolder(this, tarFolder);
}
Folder.prototype.getFilesRecursive = function() {
	return getFilesRecursive(this);
}
function copyFolder (srcFolder, tarFolder) {
	var listOfFiles = new Array();
	if(!isFolder(srcFolder, true)) {
		return null;
	}
	if(!isFolder(tarFolder, true)) {
		tarFolder.create();
	}
	
    listOfFiles = srcFolder.getFiles("*.*");
    for (; listOfFiles.length > 0; ) {
        tFile = listOfFiles.pop();
        if (tFile instanceof Folder) {
            var tempFolder = Folder(tarFolder.fsName.concat("\\", tFile.displayName));
            
			if (!isFolder(tempFolder, true)) {
				tempFolder.create()
			}
            
			tFile.copy(tempFolder);
        }
        else {
            tFile.copy(tarFolder.fsName.concat("\\", tFile.displayName));
        }
    }
}
function getFilesRecursive(folder) {
	var editfiles = new Array();
	var files = folder.getFiles("*.*");
	for(var i = 0; i<files.length; i++)
	{
		var tempfile = files[i];
		if (isFolder(tempfile)) {/* Load folder recursive */
			var tmpfolder = new Folder(tempfile);
			var temparray = getFilesRecursive(tmpfolder);
			editfiles = editfiles.concat(temparray);
		}
		else if(isFile(tempfile)) {
			 editfiles.push(tempfile);
		}
	}
	return editfiles;
}
function removeFolder(folder) {
	
	var string = 'rd "'+folder.fsName+'" /s /q';
	ExecuteBatchFile(string);
	
}
function isFolder(folder, mustexist) {/*This is a function and not a prototype because this function must be available for all data types*/
	if(!mustexist) {
		mustexist = false;
	}
	
	var isfolder = false;
	if(folder instanceof Folder)
	{
		isfolder = true;
		
		if(mustexist) {
			if(!folder.exists) {
				isfolder = false;
			}
		}
	}
	return isfolder
}
Object.prototype.isLinked = function(type) {
	return isLinkedFile(this, type);
}
function isLinkedFile(file, type) {
	if(RHInit == false) {/* RoboHelp must be available before this can be called. */
		return null;
	}
	
	/*This function works for the FileManager and the TopicManager.*/
    var alltypes = "all";
    if(!type) {
        type = alltypes;
	}
 
	if(currentProject == null)
    {
        alert("Please load the project info using the function loadcurrentproject().");
        return null;
    }

	var allowedparents = new Array("[object TopicManager]", "[object FileManager]");
	if(!in_array(file.parent, allowedparents))
	{
		alert("The isLinked method can only be used on topics from the TopicManager and files from the FileManager.");
		return null;
	}
	
	if(!file.valid) {/*Check to see if topic/file exists*/
        return false;
	}
	
	if(!is_array(LinkedFMDocs) || !is_array(LinkedWordDocs)) {
		loadLinkedFiles();
	}
    
	var FileRelPath = file.path.substring(projectpath().length).replace(/\//g, "\\");
		
	var LinkedFiles = new Array();
    var linked = false;
 
    if(type.toLowerCase() == "framemaker" || type == alltypes) {/*Check FM*/
        LinkedFiles = LinkedFiles.concat(LinkedFMDocs);
	}
    if(type.toLowerCase() == "word" || type == alltypes) {/*Check Word*/
        LinkedFiles = LinkedFiles.concat(LinkedWordDocs);
	}
 
	if(in_array(FileRelPath.toLowerCase(), LinkedFiles.toLowerCase())) {
		linked = true;
	}
		
    return linked;
}
function unloadLinkedFiles() {
	LinkedFMDocs = false;
	LinkedWordDocs = false;
}
function loadLinkedFiles() {
	if(RHInit == false) {/* RoboHelp must be available before this can be called. */
		return null;
	}
	
	var Xpath = "//genfile/filename";
	var loadFilesThatAreLinked = function(filepath) {
		var LinkedFiles = new Array();
        var ContainerFile = new File(filepath);
        if(ContainerFile.exists)
        {
			var ContainerXML = new XML(readFile(ContainerFile));
			var LinkedFilesinContainer = ContainerXML.xpath(Xpath).children();
			for(var i = 0; i< LinkedFilesinContainer.length();i++)
			{
				LinkedFiles.push(LinkedFilesinContainer[i].toString());
			}
			return LinkedFiles;
        } else {
			return null;
		}
    }
	/*Load FrameMaker*/
	LinkedFMDocs = loadFilesThatAreLinked(projectpath()+FMContainer);
	/*Load Word*/
	LinkedWordDocs = loadFilesThatAreLinked(projectpath()+WordContainer);
}
function setLogFile(fullpath) {
	var tempfile = new File(fullpath);
	if(isFile(tempfile)) {
		logfile = tempfile;
	}
}
function log(logmessage) {

	/* Create timestamp for use in log file */
	var date = new Date();
	var year = date.getFullYear().toString();
	var month = date.getMonth().toString();
    var day = date.getDay().toString();
	var time = date.getHours().toString() + ':' + date.getMinutes().toString() + ':' + date.getSeconds().toString();
	var timestamp = year+'-'+month+'-'+day+' '+time;

    /*Initialize the log file only once.*/
    if(logfile == false) {
		var logfilename = "RoboHelp_ExtendScript_Log.log";
		var folder = $.fileName;/* When log file is not specified (with setLogFile) save the log file in the same folder as the script. */
		folder = folder.replace(/\\/g,"/");
		folder = folder.substring(0,folder.lastIndexOf("/")+1);
		logfile = new File(folder+logfilename);
	}
	/* Open the log file. Create if it does not exist. */
	if(isFile(logfile, true)) {
		logfile.open("a");
	} else {
		logfile.open("w+");
	}
    
	/* Write log file contents */	
	logfile.write(timestamp+"\t"+logmessage+"\n");
	logfile.close();     

}
function isValidType(value) {
    if (typeof (value) !== 'undefined' && value != null) {
        return true;
    }
    return false;
}

function confirm(message, noAsDflt, title) {
	/* Shorthand for Window.confirm because RoboHelp doesn't support the shorthand. */
	if(!message) {
		return null;
	}
	if(!noAsDflt) {
		noAsDflt = false;
	}
	if(!title) {
		title = false;
	}
	
	if(title == false) {
		return Window.confirm(message, noAsDflt);
	} else {
		return Window.confirm(message, noAsDflt, title);
	}
}

function prompt(message, preset, title) {
	/* Shorthand for Window.prompt because RoboHelp doesn't support the shorthand. */
	if(!message) {
		return null;
	}
	if(!preset) {
		preset = "";
	}
	if(!title) {
		title = false;
	}
	
	if(title == false) {
		return Window.prompt(message, preset);
	} else {
		return Window.prompt(message, preset, title);
	}
}
function uniqueid() {/*Return a unique id*/
	
	var result, i, j;
	result = '';
	for(j=0; j<32; j++)
	{
		if( j == 8 || j == 12|| j == 16|| j == 20) {
		result = result + '-';
		}
		i = Math.floor(Math.random()*16).toString(16).toUpperCase();
		result = result + i;
	}
	return 'uid-'+result
	
}
function clearmsg() {
	if(RHInit == false) {/* RoboHelp must be available before this can be called. */
		return null;
	}
	if(IsRoboHelp9OrLater() && currentProject != null) {
		RoboHelp.project.clearOutputViewLog();
	}
}
function closeproject() {
	if(RHInit == false) {/* RoboHelp must be available before this can be called. */
		return null;
	}
	if(currentProject == null)
	{
		loadcurrentproject(false);
		if(currentProject == null)
		{
			alert("Cannot close the current project as there is no project opened.");
			return null;
		}
	}
	
	var tmpproject = currentProject;
	unloadcurrentproject();
	RoboHelp.closeProject();
	return true;
}
function loadcurrentproject(showerror) {/*If project is loaded after the library is initialized, this function must be run to initialize the variable currentProject*/
	if(RHInit == false) {/* RoboHelp must be available before this can be called. */
		return null;
	}
	
	if(!showerror) {
		if(showerror != false) {
			showerror = true;
		}
	}
	
	if(projectavailable()) {
		currentProject = RoboHelp.getCurrentProject();
	} else if(showerror) {
		alert("There is no RoboHelp project to load. Try loading the project and calling the function getcurrentproject() again.");
	}
}
function msg(message) {
	if(RHInit == false) {/* RoboHelp must be available before this can be called. */
		return null;
	}
	if(currentProject != null) {
		RoboHelp.project.outputMessage(message);
	}
}
function openproject(xpjpath, updateifrequired) {
	if(RHInit == false) {/* RoboHelp must be available before this can be called. */
		return null;
	}
	
	if(!updateifrequired) {
		updateifrequired = false;
	}
	
	if(!isValidType(xpjpath) || !isValidFilePath(xpjpath, xpjextension)) {
		return false;
	}
	
	var prj = new File(xpjpath);
	if(folder(prj.fsName)+"/" == projectpath())
	{
		alert("This project is already open.");
		return false;
	}
	else
	{
		unloadcurrentproject();/*Unload current project from variable currentProject.*/
		RoboHelp.openProject(prj.fsName, updateifrequired);/*Open project*/
		loadcurrentproject(false);/*Load opened project into variable currentProject.*/
		return true;
	}
	
}
function openprojectdialog(updateifrequired) {
	if(RHInit == false) {/* RoboHelp must be available before this can be called. */
		return null;
	}
	
	if(!updateifrequired) {
		updateifrequired = false;
	}
	
	var prj = new File();
	prj = prj.openDlg("Choose project to open", "Project file:*.xpj", false);
	if(!isValidType(prj) || !isValidFilePath(prj.fsName, xpjextension)) {
		return false;
	}
	
	return openproject(prj.fsName, updateifrequired);

}
function unloadcurrentproject() {
	unloadCSH();
	unloadLinkedFiles();
	currentProject = null;
}
function projectavailable() {
	if(RHInit == false) {/* RoboHelp must be available before this can be called. */
		return null;
	}
	if(isValidType(RoboHelp.getCurrentProject()))
		return true;
	else
		return false;
}

function projectpath() {
	if(RHInit == false) {/* RoboHelp must be available before this can be called. */
		return null;
	}
	if(currentProject != null) {
		return currentProject.path.replace(/\\/g, "/")+"/";
	} else {
		return null;
	}
}
function projecttitle() {
	if(RHInit == false) {/* RoboHelp must be available before this can be called. */
		return null;
	}
	if(currentProject != null) {
		return currentProject.title;
	} else {
		return null;
	}
}
function projectlanguage() {
	if(RHInit == false) {/* RoboHelp must be available before this can be called. */
		return null;
	}
	
	if(currentProject == null) {
		return null
	} else {
		var projectlang = "en";
		if (IsRoboHelp9OrLater()) {
			try {
				projectlang = RoboHelp.Language.getNameFromID(currentProject.language);
			} catch (e) {
				/*Silently swallow exceptions*/
			}
		}
		return projectlang;
	}
}
function IsRoboHelp9OrLater() {
	if(RHInit == false) {/* RoboHelp must be available before this can be called. */
		return null;
	}
    var versionString = RoboHelp.version;
    var iVersion = parseInt(versionString);
    return (iVersion >= 9);
}
function IsRoboHelp10OrLater() {
	if(RHInit == false) {/* RoboHelp must be available before this can be called. */
		return null;
	}
    var versionString = RoboHelp.version;
    var iVersion = parseInt(versionString);
    return (iVersion >= 10);
}
function saveSetting(setting, value, scope) {
    if(!scope) {
        scope = "project";
    }
	
	/* Make tagname safe */
	setting = safeTagName(setting);
	
	if(RHInit == false) {/* When RoboHelp is not opened, the scope is always global */
		scope = "global"
	}
	
    if(currentProject == null && scope != "global") {
		return false;
	}

	var settings = allSettings(scope);
	if(settings == false || string_isEmpty(settings.toString())) {/*No file yet or empty*/
		settings = new XML("<scriptsettings/>");
	}
	
	/*Is this setting already availble?*/
	if(!string_isEmpty(trim(settings.child(setting).toString()))) {
		settings.replace(setting, new XML("<"+setting+"><![CDATA["+htmlspecialchars(value)+"]]></"+setting+">"));/*Replace existing value*/
	} else {
		settings.appendChild(new XML("<"+setting+"><![CDATA["+htmlspecialchars(value)+"]]></"+setting+">"));/*Add new value*/
	}

	
	var settingsFileResource = getSettingsFile(scope);
    writeFile(settingsFileResource, "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n"+settings.toXMLString());
	return true;
}
function loadSetting(setting, scope) {
	
	/* Make tagname safe */
	setting = safeTagName(setting);

	if(!scope) { scope = "project"; }
	
	if(RHInit == false) {/* When RoboHelp is not openend, the scope is always global */
		scode = "global";
	}
    
    if(currentProject == null && scope != "global") {
		return null;
	}
	var settings = allSettings(scope);
	if(settings == false || string_isEmpty(settings.toString())) {
		return null;
	} else {
		return settings.child(setting).toString();
	}
}
function allSettings(scope) {
    var settingsFileResource = getSettingsFile(scope);
	if(isFile(settingsFileResource), true)/*Does the settings file already exist?*/
		return new XML(readFile(settingsFileResource));
	else
		return false;
}
function getSettingsFile(scope) {
    /*Settings file name*/
    var settingsFile = "scriptSettingFile.xml";
    
    if(scope == "global") {
        var settingsFile = new File(Folder.appData.fsName + '/'+ settingsFile);
    } else if (currentProject != null){
        var settingsFile = new File (projectpath()+settingsFile);
    } else {
        var settingsFile = null;
    }
    return settingsFile;
}
Object.prototype.outputDir = function() {
	return ssl_outputDir(this);
}
function ssl_outputDir(SSL) {
	if(RHInit == false) {/* RoboHelp must be available before this can be called. */
		return null;
	}
	
	if(SSL.parent != "[object SSLManager]") {
	   alert("You can only use the method/function outputDir() on SSL objects");
	   return null;
	}
	
	return folder(SSL.outputFileName)+"/";
}
String.prototype.count = function (s1) {   
	return string_count(this.toString(), s1);
}
String.prototype.isEmpty = function () {
	return string_isEmpty(this.toString());
}
String.prototype.toBoolean = function() {
	return string_toBoolean(this.toString());
}
String.prototype.trim = function() {
	return trim(this.toString());
}
function string_count(string, s1) {
	if(typeof(string) != "string") {
		return null;
	}
	return (string.length - string.replace(new RegExp(s1,"g"), '').length) / s1.length;
}
function string_isEmpty(string) {
	if(typeof(string) != "string") {
		return null;
	}
	var isempty = true;
	if(isValidType(string))
	{
		if(trim(string).length > 0) {
			isempty = false;
		}
	}
	return isempty;
}
function string_toBoolean(string) {
	if(typeof(string) != "string") {
		return null;
	}
	var truearray = new Array("true", "1");
	var falsearray = new Array("false", "0", "-1");
	if(in_array(string, truearray)) {
		return true;
	} else if(in_array(string, falsearray)) {
		return false;
	} else {
		return null;
	}
}
function trim(string) {
	if(typeof(string) != "string") {
		return null;
	}
	return string.replace(/^\s+|\s+$/g, "");
}
Object.prototype.balancedDelete = function (contentdelete) {
	return token_balancedDelete(this, contentdelete);
}
Object.prototype.hasAttribute = function(attribute, empty) {
	return token_hasAttribute(this, attribute, empty);
}
Object.prototype.isTag = function(Tag, casesensitive) {
	return token_isTag(this, Tag, casesensitive);
}
function token_balancedDelete(Token, contentdelete) {
	if(RHInit == false) {/* RoboHelp must be available before this can be called. */
		return null;
	}
 
    if(Token.parent != "[object TokenManager]")
    {
        alert("You can only use the balancedDelete function on tokens from the TokenManager.");
        return null;
    }
 
    var SingleDelete = function(token) {
        var Single = false;
 
        if(token.tokenType == RoboHelp.TokenType.TOKENTEXT)
        {
            Single = true;
        }
        else if(token.tokenType == RoboHelp.TokenType.TOKENTAG)
        {
            if(token.name.match(/(<\/)/g) || token.name.match(/(\/>)/g))/* End tags or shorthand tags */
                Single = true;
            else
            {   
				/* If no match of yet, make sure that the tag is not a known html shorthand tag. HTML 4.01 allows shorthand tags like <br> */
				var ShortTags = new Array("area","base","basefont","br","col","frame","img","input","link","meta","param");
				if(token_isTag(token, ShortTags))
					Single = true;
			}
        }
        return Single;
    }
 
    if(SingleDelete(Token))
    {
		Token.delete();
	}
    else
    {
            var TokenDelete = new Array(Token);
            var tag = cleantag(Token.name);
            var endTag = "/"+tag;
            var i = 0;
            var RetreivedAll = false;
            var sToken = Token.next;
            while(RetreivedAll == false)
            {
                if(token_isTag(sToken, tag))
                {
                    i++;
                    if(contentdelete)
                        TokenDelete.push(sToken);
                }
                else if(token_isTag(sToken, endTag) && i != 0)
                {
                    i--;
                    if(contentdelete)
                        TokenDelete.push(sToken);
                }
                else if(token_isTag(sToken, endTag) && i == 0)
                {
                    TokenDelete.push(sToken);
                    RetreivedAll = true;
                 }
                else if(contentdelete)
                    TokenDelete.push(sToken);
 
                sToken = sToken.next;
            }
 
            for(var j = 0;j<TokenDelete.length;j++)
            {
                TokenDelete[j].delete();
            }
     }
    return true;
}
function token_hasAttribute(Token, attribute, empty) {
	if(RHInit == false) {/* RoboHelp must be available before this can be called. */
		return null;
	}
 
     if(!empty)
        empty = false;
	
	if(Token.parent != "[object TokenManager]")
    {
        alert("You can only use the hasAttribute functions on tokens from the TokenManager.");
        return null;
    }
    else if(!attribute)
    {
        alert("No attribute specified");
        return null;
    }
 
    if(Token.tokenType != RoboHelp.TokenType.TOKENTAG)/* It's not a tag at all */
        return false;
 
    var hasAttribute = false;
 
    if(Token.getAttribute(attribute) != "")
        hasAttribute = true;
    else if(empty)/* Search for empty attribute */
    {
        var attrstring = attribute+'=("|\')';/* Append =" or =' to attribute name. */
        var attr = new RegExp(attrstring);
        if(Token.name.match(attr))
            hasAttribute=true;
    }
 
    return hasAttribute;
}
function token_isTag(Token, Tag, casesensitive) {
	if(RHInit == false) {/* RoboHelp must be available before this can be called. */
		return null;
	}
	
	if(!casesensitive)
		casesensitive = false;
 
    if(Token.parent != "[object TokenManager]")
    {
        alert("You can only use the isTag functions on tokens from the TokenManager.");
        return null;
    }
 
    if(Token.tokenType != RoboHelp.TokenType.TOKENTAG)/* It's not a tag at all */
        return false;
 
    if(!Tag)/* No tag specified and this is a tag so return true */
        return true;
 
    var isTag = false;
    var fullTag = Token.name;
    var TagName = cleantag(fullTag);/* Get the tag name without brackets */
 
    if(!is_array(Tag))
    {
        var TagArray = new Array;
        TagArray[0] = Tag;
    } else {
        var TagArray = Tag;
    }
	
	if(!casesensitive)
	{
		/* Matching is not case sensitive. Put everything in lower case */
		TagName = TagName.toLowerCase();
		TagArray = array_toLowerCase(TagArray);
	}
 
	if(in_array(TagName, TagArray))
		isTag = true;

    return isTag;
}
function  cleantag (tag) {
	if(tag.match(" ")) {
		tag = tag.split(" ")[0];/* Remove attributes the lazy way. All attributes are separated by spaces from the tag name. */
	}
	
	tag = tag.replace(/[<>]/g, "");
	
    if(tag.substr(-1) == "/") {
		tag = tag.substr(0,tag.length-1);
	}
	
	return tag;
}
Object.prototype.CSH = function(topicid, mapnumber) {
	return topicCSH(this, topicid, mapnumber);
}
function topicCSH(topic, topicid, mapnumber) { 
	if(RHInit == false) {/* RoboHelp must be available before this can be called. */
		return null;
	}
	
	/*Object to get the CSH of a topic.*/
	if(topic.parent != "[object TopicManager]") {
		alert("The CSH method can only be used on topics from the TopicManager");
		return null;
	}
	
	/*Project CSH settings are not initialized yet.*/
	if(CSH == false)
		loadCSH();
	
	var topicrelpath = topic.path.toLowerCase().replace(/\\/g, "/").replace(projectpath().toLowerCase(), "");
	
	if(!topicid) {
		topicid = false;
		mapnumber = false;
	}
	
	/*Get the CSH for the topic and return that.*/
	if(topicid === false) {
		var topicCSH = new Array();
		
		for(var i = 0; i<CSH.length; i++) {
			if(CSH[i][CSHTopicKey] != false) {
				if(CSH[i][CSHTopicKey].toLowerCase() == topicrelpath) {
					var tmpArray = [];
					tmpArray[CSHTopicidKey] = CSH[i][CSHTopicidKey];
					tmpArray[CSHMapnumberKey] = CSH[i][CSHMapnumberKey];
					
					topicCSH.push(tmpArray);
				}
			}
		}
		
		if(topicCSH.length >= 1)
			return topicCSH;
		else
			return false;
			
	} else {/*Set CSH for the topic.*/
		
		msg("\nSetting CSH for topic \""+topicrelpath+"\"\n");
		
		var returnvalue = true;
		
		if(!in_array(topicid, TopicIds) && !in_array(mapnumber, MapNumbers)) {
			
			currentProject.MapIdManager.newMapId(topicid, mapnumber);
			currentProject.MapIdManager.assign(topicid, topicrelpath);
			
			/*Add new mapnumbers to the correct arrays*/
			var tmpArray = new Array();
			tmpArray[CSHTopicidKey] = topicid;
			tmpArray[CSHMapnumberKey] = mapnumber;
			tmpArray[CSHTopicKey] = topicrelpath;
			CSH.push(tmpArray);
			
			MapNumbers.push(mapnumber);
			TopicIds.push(topicid);
		} else if (in_array(topicid, TopicIds) && in_array(mapnumber, MapNumbers)) {
			/*Assume that given id's are assigned correctly.*/
			currentProject.MapIdManager.assign(topicid, topicrelpath);
			/*Assign the topic to the id's in the CSH array.*/
			for(var i = 0; i<CSH.length; i++) {
				if(CSH[CSHTopicidKey] == topicid) {
					CSH[CSHTopicKey] = topicrelpath;
					break;
				}
			}
		} else {
			/*There is something wrong*/
			returnvalue = false;
			alert("Error while assigning CSH. Map# and TopicId must both exist or must both be absent from project.");
		}
		
		return returnvalue;
		
	}
}
/* Support functions for File.convertUTF8()*/
File.prototype.convertUTF8 = function (fileencoding) {
	return convertUTF8(this, fileencoding);
}
function convertUTF8(file, fileencoding) {
	if(!isFile(file, true)) {
		return false;
	}
	if(!fileencoding) {/*Default file encodings*/
		fileencoding = 'iso-8859-1';
	}
   
	content = readFile(file, fileencoding);
	writeFile(file, content);
	return true;
}
function htmlspecialchars(string) {
	if(!string.isEmpty()) {
	   string = string.replace(/&/g,"&amp;");
	   string = string.replace(/</g,"&lt;");
	   string = string.replace(/>/g,"&gt;");
	   string = string.replace(/"/g,"&#039;");
	   string = string.replace(/'/,"&apos;");
	}
	return string;
}
function safeTagName(string) {
	string = string.replace(/[^a-zA-Z0-9_]/g, "_");
	if(string.substring(0,1).match(/[^a-zA-Z]/g, "_")) {
		string = "safe_"+string;
	}
	return string;
}
File.prototype.zip = function (zipname, method, compression, archivecommand) {/* Zip a single file */
	return zipFile(this, zipname, method, compression, archivecommand);
}
Folder.prototype.zip = function (zipname, method, compression, archivecommand) {/* zip a folder. This is always recursive */
	return zipFolder(this, zipname, method, compression, archivecommand);
}
function zipFile(file, zipname, method, compression, archivecommand) {/* Zip a single file */	
	if(!isFile(file, true))
	{
		alert("File "+file.fsName+" does not exist. Cannot zip file.");
		return false;
	}
	else if(!ZipLocation())/*No location. Cannot zip file*/
	{
		return false;
	} 
	else if(string_isEmpty(zipname))
	{
		alert("No name for archive specified. Cannot zip file "+file.fsName);
		return false;
	}

	if(!method) {
		method = "tzip";
	}
	if(!compression) {
		compression = false;
	}
	if(!archivecommand) {
		archivecommand = "a";
	}
		
	var batchtxt = "";
		
	if(validZipMethod(method) && validZipCompression(compression) && validArchiveCommand(archivecommand))
	{
		batchtxt+='"'+v7Location+'" '+archivecommand+' -'+method+' "'+zipname+'" '+'"'+file.fsName+'"';
		if(compression != false)
			batchtxt+=' -mx'+compression;
			
		return ExecuteBatchFile(batchtxt);
	}
	else
	{
		alert("Invalid options for archive specified. Cannot zip file "+file.fsName);
		return false;
	}
}
function zipFolder(folder, zipname, method, compression, archivecommand) {/* zip a folder. This is always recursive */
	if(!isFolder(folder, true))
	{
		alert("Folder "+folder.fsName+" does not exist. Cannot zip folder.");
		return false;
	}
	else if(!ZipLocation())/*No location. Cannot zip file*/
	{
		return false;
	}
	else if(string_isEmpty(zipname))
	{
		alert("No name for archive specified. Cannot zip file "+file.fsName);
		return false;
	}

	if(!method) {
		method = "tzip";
	}
	if(!compression) {
		compression = false;
	}
	if(!archivecommand) {
		archivecommand = "a";
	}
	
	var batchtxt = "";
	
	if(validZipMethod(method) && validZipCompression(compression) && validArchiveCommand(archivecommand))
	{
		batchtxt+='"'+v7Location+'" '+archivecommand+' -'+method+' "'+zipname+'" '+'"'+folder.fsName+"\\*"+'"';
		if(compression != false)
			batchtxt+=' -mx'+compression;
			
		return ExecuteBatchFile(batchtxt);
	}
	else
	{
		alert("Invalid options for archive specified. Cannot zip folder "+folder.fsName);
		return false;
	}
}
/* Support functions for File.zip() and Folder.zip() */
function isValid7ZipPath () {
	if(!isValidFilePath(v7Location, "7z.exe")  && !isValidFilePath(v7Location, "7za.exe")) {
		return false;
	} else {
		return true;
	}
}
function validArchiveCommand(archivecommand) {
	var v7commands = new Array("a", "u");/*Add to archive (or create new) / update file in archive */
	if(in_array(archivecommand, v7commands)) {
		return true;
	} else {
		return false;
	}
}
function validZipCompression(compression) {
	var v7compression = new Array("0", "1", "3", "5", "7", "9", false);/*Compression goes: none, very low, fast, normal, high, ultra, use 7zip default.*/
	if(in_array(compression, v7compression)) {
		return true;
	} else {
		return false;
	}
}
function validZipMethod(method) {
	var v7methods = new Array("t7z", "tgzip", "tzip", "tbzip2", "tiso", "tudf");/*Supported archive types.*/
	if(in_array(method, v7methods)) {
		return true;
	} else {
		return false;
	}
}
function ZipLocation() {/*Add location of 7-Zip executable to v7Location. (Script duration only.) Return true on succes, false on fail.*/
	if(!isValid7ZipPath())
	{
		var ziploc = new File();
		ziploc = ziploc.openDlg("Please choose 7-Zip executable to zip the file","7-Zip executable: 7z.exe;7za.exe");
		if(isFile(ziploc, false)) {
			v7Location = ziploc.fsName;
		}
			
		if(!isValid7ZipPath())
		{
			alert("The path to 7-Zip is not valid.");
			return false;
		}
	}
	return true;
}
	
/* Function used to initialize the library */
function libInit() {
	RHInit = false;
	libVersion = 20130506;
	currentProject = null;	
	
	if(typeof(v7Location) == "undefined") {/* Initialize global vars. */
		/*
		 *
		 * All global variables and methods are set initialized in this function because RH10 events dont instantiate global variables.
		 * This is bad practice. If you have a better solution, please let me know (http://www.wvanweelden.eu/contact).
		 *
		 */
		 
		v7Location = null;
		xpjextension = ".xpj";
		
		/*Container files*/
		FMContainer = "RHFrameDocs.apj";
		WordContainer = "RHWordDocs.apj";
		aliasfileextension = ".ali";
		mapfileextension = new Array(".h", ".hh", ".hm");

		/*Linked file information variables*/
		LinkedFMDocs = false;
		LinkedWordDocs = false;
		/*CSH information variables*/
		CSH = false;
		MapNumbers = new Array();
		TopicIds = new Array();
		CSHTopicidKey = "topicid";
		CSHMapnumberKey = "mapnumber";
		CSHTopicKey = "topic";
		CSHHighestNumberTaken = false;
		CSHNoMoreMapNumbers = false;
		CSHLastAssignedNumber = false;
		/*Log file*/
		logfile = false;
		
	}
	
	/* Is RoboHelp available? */
	if(typeof(RoboHelp) != "undefined") {
		RHInit = true;
		loadcurrentproject(false);/*Load the current project into the variable currentProject.*/
	}
}
libInit();/* Auto init library */

/* Include dependant files. */
function initGlobal() {
	version = '2014-09-23';

	/* Dialog internal */
	listBox = null;
	currentItem = false;

	dialogURL = null;
	dialogFrequency = null;
	dialogSettings = new Array();
	dialogURLPlaceholder = 'url';
	dialogFrequencyPlaceholder = 'frequency';

	autorunenabled = 'Autorun is enabled. Click to disable.';
	autorundisabled = 'Autorun is disabled. Click to enable.';

	sitemapentries = new Array();

	/* Settings */
	urlSettingPrefix = "sitemap_url_";
	changeFrequencySettingPrefix = "sitemap_fequency_";
	changeFrequencies = new Array();

	savedSettings = new Array();
	dialogSettings = new Array();

	sitemapfilename = 'sitemap.xml';

	settingsText = "Settings for SSL %1";

	/* Supported layouts */
	supportedLayouts = new Array(
		RoboHelp.SSLLayoutType.FLASHHELP,
		RoboHelp.SSLLayoutType.FLASHHELPPRO,
		RoboHelp.SSLLayoutType.MULTISCREENHTML5,
		RoboHelp.SSLLayoutType.RESPONSIVEHTML,
		RoboHelp.SSLLayoutType.WEBHELP,
		RoboHelp.SSLLayoutType.WEBHELPPRO,
	);

	/* HTML5 output files */
	HTML5Files = new Array(
		'access_cookies.htm',
		'searchresults.htm',
	);

	/* WebHelp output files (Also contains FlasHelp files) */
	WebHelpFiles = new Array(
		'contentlist.xml',
		'cshdat_webhelp.htm',
		'cshdat_robohelp.htm',
		'whcsh_home.htm',
		'whcshdata.htm',
		'whfbody.htm',
		'whfdhtml.htm',
		'whfform.htm',
		'whgbody.htm',
		'whgdef.htm',
		'whgdhtml.htm',
		'whibody.htm',
		'whidhtml.htm',
		'whiform.htm',
		'whnjs.htm',
		'whproj.htm',
		'whskin_banner.htm',
		'whskin_blank.htm',
		'whskin_frmset01.htm',
		'whskin_frmset010.htm',
		'whskin_homepage.htm',
		'whskin_info.htm',
		'whskin_mbars.htm',
		'whskin_pdhtml.htm',
		'whskin_pickup.htm',
		'whskin_plist.htm',
		'whskin_tbars.htm',
		'whskin_tw.htm',
		'whtdhtml.htm',
		'ehlpdhtm.js',
		'whfhost.js',
		'whform.js',
		'whframes.js',
		'whghost.js',
		'whhost.js',
		'whihost.js',
		'whlang.js',
		'whmozemu.js',
		'whmsg.js',
		'whphost.js',
		'whproj.js',
		'whproxy.js',
		'whstart.js',
		'whstub.js',
		'whtbar.js',
		'whthost.js',
		'whtopic.js',
		'whutils.js',
		'whver.js',
		'robohhre.lng',
		'whbrs.xml',
		'whproj.xml',
		'whres.xml',
		'whst_topics.xml',
		'whstart.ico',
		'whrstart.ico',
		'whestart.ico',
		'xmlreadhelper.js',
		'whd_dpns.htm',
		'whd_nvp10.htm',
		'whd_nvp20.htm',
		'whd_tabs.htm',
		'whskin_ep_start.htm',
		'whskin_ep_ins.xml',
		'flashhelp_components.swf',
		'flashhelp_tooltip_component.swf',
		'skin_aboutbox.swf',
		'skin_background_nav.swf',
		'skin_background_navpane.swf',
		'skin_background_tb.swf',
		'skin_button_nav_close.swf',
		'skin_button_nav_next.swf',
		'skin_button_nav_previous.swf',
		'skin_button_nav_sync.swf',
		'skin_button_tb_glossary.swf',
		'skin_button_tb_index.swf',
		'skin_button_tb_poweredby.swf',
		'skin_button_tb.print.swf',
		'skin_button_tb_search.swf',
		'skin_button_tb_toc',
		'skin_glossary.swf',
		'skin_index.swf',
		'skin_scrollbar.swf',
		'skin_search.swf',
		'skin_textfield.swf',
		'skin_textnode.swf',
		'skin_toc.swf',
		'wf_blank.htm',
		'wf_bottom.htm',
		'wf_checkflash.htm',
		'wf_comm.htm',
		'wf_contentfs.htm',
		'wf_detectflash.swf',
		'wf_dispatcher.js',
		'wf_dispatcher.vbs',
		'wf_favicon.ico',
		'wf_filestatus.htm',
		'wf_filestatus.swf',
		'wf_flashinstall.htm',
		'wf_flashupgrade.htm',
		'wf_frames.js',
		'wf_glossary.swf',
		'wf_glossaryui.swf',
		'wf_glossaryxml.swf',
		'wf_hiddenfs.htm',
		'wf_index.swf',
		'wf_indexui.swf',
		'wf_indexxml.swf',
		'wf_master.htm',
		'wf_master.swf',
		'wf_master.js',
		'wf_navbar.htm',
		'wf_navbar.swf',
		'wf_navframe.htm',
		'wf_navpane.htm',
		'wf_navpane.swf',
		'wf_njs.htm',
		'wf_param_passer.swf',
		'wf_pickup.htm',
		'wf_poweredby.htm',
		'wf_poweredby.swf',
		'wf_related.htm',
		'wf_related.swf',
		'wf_search.swf',
		'wf_searchsvr.swf',
		'wf_searchui.swf',
		'wf_searchxml.swf',
		'wf_skin.htm',
		'wf_skin.swf',
		'wf_startfs.htm',
		'wf_startpage.js',
		'wf_startqs.htm',
		'wf_status.htm',
		'wf_swfcomm.js',
		'wf_system_stock_aboutbox.swf',
		'wf_system_stock_poweredby.swf',
		'wf_toc.swf',
		'wf_tocui.swf',
		'wf_tocxml.swf',
		'wf_toolbar.htm',
		'wf_toolbar.swf',
		'wf_topic.swf',
		'wf_topic_passer.swf',
		'wf_topiccomm.htm',
		'wf_topiccomm.swf',
		'wf_topicfs.htm',
		'wf_topicfs2.htm',
		'wf_topicpp.htm',
		'wf_topics.css',
		'wf_update.xml',
		'wf_updatestatus.htm',
		'wf_updatestatus.swf',
		'wf_waitv6.swf',
		'wfres.xml',
	);
	
dialogSrc = "dialog{\
	properties: { \
        closeButton: true \
    }, \
	text:'Sitemap generator', \
	preferredSize: [570,410], \
	align: Group { \
		alignChildren: 'row', \
		alignment:['left','top'], \
		SSLList: ListBox { \
			bounds: [5,5,195,405], \
		}, \
		SSLProperties: Panel { \
			bounds: [210,5,560,405], \
			type: 'panel', \
			text: '', \
			br:StaticText { \
				text: ' ', \
				bounds: [130,10,340,30], \
			}, \
			urlText: StaticText { \
				text: 'The URL where the help will be published:', \
				bounds: [130,40,340,60], \
			}, \
			url:EditText { \
				bounds: [10,60,340,80], \
			}, \
			freqText: StaticText { \
				text: 'How often does the content change:', \
				bounds: [160,110,340,130], \
			}, \
			frequency: DropDownList { \
				bounds: [250,130,340,155], \
				always: ListItem { text: 'always', }, \
				hourly: ListItem { text: 'hourly', }, \
				daily: ListItem { text: 'daily', }, \
				weekly: ListItem { text: 'weekly', }, \
				monthly: ListItem { text: 'monthly', }, \
				yearly: ListItem { text: 'yearly', }, \
				never: ListItem { text: 'never', }, \
			},\
			txt1: StaticText { \
				bounds: [10, 180, 340, 195], \
				text: 'The URL of the help must be the full path to the help.', \
			}, \
			txt2: StaticText { \
				bounds: [10, 200, 340, 215], \
				text: 'Example: http:\/\/www.example.com\/help\/projectname\/', \
			}, \
			txt3: StaticText { \
				bounds: [10, 220, 340, 235], \
				text: 'The sitemap will only work with a complete URL.', \
			}, \
		}, \
	}, \
	copyright: Group { \
		alignment:['right','bottom'], \
		cp: StaticText { text: 'Version "+version+" - Copyright Willam van Weelden - www.wvanweelden.eu', }, \
	}, \
	buttons: Group { \
		alignment:['right','bottom'], \
		run: Button { text: 'Generate Sitemap', }, \
		save: Button { text: 'Save', }, \
		abort: Button { text: 'Cancel', }, \
	}, \
}"; 

	dialog = new Window(dialogSrc);
}
function showDialog() {
	/* For RH8/9 compatibility */
	if(typeof(RoboHelp.SSLLayoutType.MULTISCREENHTML5) == "undefined") {
		RoboHelp.SSLLayoutType.MULTISCREENHTML5 = 19;
	}
	if(typeof(RoboHelp.SSLLayoutType.RESPONSIVEHTML) == "undefined") {
		RoboHelp.SSLLayoutType.RESPONSIVEHTML = 21;
	}

	/* Set shortcuts for value holders */
	listBox = dialog.align.SSLList;
	dialogURL = dialog.align.SSLProperties.url;
	dialogFrequency = dialog.align.SSLProperties.frequency;
	
	/* Add available layouts to the dialog */
	var SSLs = currentProject.SSLManager;
	for(var i=1; i<=SSLs.count; i++) {
		var SSL = SSLs.item(i);
		if(in_array(SSL.layoutType, supportedLayouts)) {
			listBox.add('item', SSL.name);
		}
	}
	
	/* Set on change value event */
	listBox.onChange = ViewClick;
	
	if(listBox.children.length > 0) {
		listBox.children[0].selected = true;
	}
	
	/* Set save event */
	dialog.buttons.save.onClick = saveDialogClick;
	dialog.buttons.run.onClick = startCreateSitemap;
	
	if(IsRoboHelp10OrLater()) {
		if(RoboHelp.isEventRegistered('PostSSLGenerate', $.fileName, 'createSitemap')) {
			dialog.align.SSLProperties.registered = dialog.align.SSLProperties.add('button', [50, 300, 290, 325], autorunenabled);
		} else {
			dialog.align.SSLProperties.registered = dialog.align.SSLProperties.add('button', [50, 300, 290, 325], autorundisabled);
		}
		dialog.align.SSLProperties.registered.onClick = swithAutorun;
	}
	
	ViewClick();
	dialog.show();
}
function swithAutorun() {
	if(RoboHelp.isEventRegistered('PostSSLGenerate', $.fileName, 'createSitemap')) {
		
		RoboHelp.unregisterEvent('PostSSLGenerate', $.fileName, 'createSitemap');
		dialog.align.SSLProperties.registered.text = autorundisabled;
		
	} else {
		
		if(RoboHelp.registerEvent('PostSSLGenerate', $.fileName, 'createSitemap')) {
			dialog.align.SSLProperties.registered.text = autorunenabled;
		} else {
			alert('Could not register script to run.');
		}
		
	}
}
function getActiveSSL() {
	for(var i=0; i<listBox.children.length; i++) {
		var item = listBox.children[i];
		if(item.selected == true) {
			var selected = item.text;
			break;
		}
	}
	return selected;
}

function ViewClick() {
	
	if(currentItem != false) {/* Temporary save settings of the current item */
		dialogSettings[currentItem][dialogURLPlaceholder] = dialogURL.text;
		for(var i = 0; i < dialogFrequency.children.length; i++) {
			if(dialogFrequency.children[i].selected == true) {
				dialogSettings[currentItem][dialogFrequencyPlaceholder] = dialogFrequency.children[i].toString();
			}
		}
	}
	
	/* Get the selected SSL */
	currentItem = getActiveSSL();
	/* Check whether settings for this SSL have been loaded */
	if(typeof(savedSettings[currentItem]) == "undefined") {
		var mySettings = new Array();
		mySettings[dialogURLPlaceholder] = (loadSetting(urlSettingPrefix+currentItem) != null) ? loadSetting(urlSettingPrefix+currentItem) : "";
		mySettings[dialogFrequencyPlaceholder] = (loadSetting(changeFrequencySettingPrefix+currentItem) != null) ? loadSetting(changeFrequencySettingPrefix+currentItem) : "yearly";
		savedSettings[currentItem] = mySettings;/* Saved settings for comparison */
		dialogSettings[currentItem] = mySettings;/* New saved values, allow for rollback */
	}
	
	/* Change panel caption */
	dialog.align.SSLProperties.text = settingsText.replace("%1", currentItem);
	dialogURL.text = dialogSettings[currentItem][dialogURLPlaceholder];
	for(var i = 0; i < dialogFrequency.children.length; i++) {
		if(dialogFrequency.children[i].toString() == dialogSettings[currentItem][dialogFrequencyPlaceholder]) {
			dialogFrequency.selection = dialogFrequency.children[i];
			break;
		}
	}
}
function saveDialogClick() {
	saveDialog();
	alert('Settings saved.');
}
function saveDialog() {
	ViewClick();//Load current dialog settings
	for(var i in dialogSettings) {
		if(isValidType(dialogSettings[i][dialogURLPlaceholder]) && !dialogSettings[i][dialogURLPlaceholder].isEmpty()) {
			saveSetting(urlSettingPrefix+i, dialogSettings[i][dialogURLPlaceholder]);
		}
		if (isValidType(dialogSettings[i][dialogFrequencyPlaceholder]) && !dialogSettings[i][dialogFrequencyPlaceholder].isEmpty()) {
			saveSetting(changeFrequencySettingPrefix+i, dialogSettings[i][dialogFrequencyPlaceholder]);
		}
	}
}
function startCreateSitemap() {
	saveDialog();
	currentItem = getActiveSSL();
	
	if(Window.confirm("Do you want to generate the SSL "+currentItem+" before creating the sitemap?")) {
		var SSLs = currentProject.SSLManager;
		for(var i=1; i<=SSLs.count; i++) {
			var SSL = SSLs.item(i);
			if(SSL.name == currentItem) {
				SSL.generate();
			}
		}
	}
	createSitemap(currentItem, true);
}

/* Run the script */
if(RHInit) {
	if(currentProject != null) {
		initGlobal();
		showDialog();
	} else if(openprojectdialog()) {
		initGlobal();
		showMainDialog();
	} else {
		alert("You must open a project to use this script.");
	}
} else {
	alert('Start RoboHelp to run this script.');
}
/* Function for generating a Sitemap. This function is called for events. */
function createSitemap(sitemapSSL, alertUser) {
	
	libInit();/* Try to instantiate the library. This is required for RH10 events */
	if(typeof(sitemapfilename) == "undefined") {
		initGlobal();/* Try to initialize the global variables. This is required for RH10 events */
	}
	
	if(!alertUser) {
		alertUser = false;
	}
	
	SSLType = false;
	
	var SSLs = currentProject.SSLManager;/* Get the SSL and check whether it's of a supported type */
	for(var i=1; i<=SSLs.count; i++) {
		var SSL = SSLs.item(i);
		if(SSL.name == sitemapSSL) {
			switch(SSL.layoutType) {
				case RoboHelp.SSLLayoutType.FLASHHELP:
					doSSL = SSL;
					SSLType = RoboHelp.SSLLayoutType.WEBHELP;
					break;
				case RoboHelp.SSLLayoutType.FLASHHELPPRO:
					doSSL = SSL;
					SSLType = RoboHelp.SSLLayoutType.WEBHELP;
					break;
				case RoboHelp.SSLLayoutType.MULTISCREENHTML5:
					doSSL = SSL;
					SSLType = RoboHelp.SSLLayoutType.MULTISCREENHTML5;
					break;
				case RoboHelp.SSLLayoutType.RESPONSIVEHTML:
					doSSL = SSL;
					SSLType = RoboHelp.SSLLayoutType.RESPONSIVEHTML;
					break;
				case RoboHelp.SSLLayoutType.WEBHELP:
					doSSL = SSL;
					SSLType = RoboHelp.SSLLayoutType.WEBHELP;
					break;
				case RoboHelp.SSLLayoutType.WEBHELPPRO:
					doSSL = SSL;
					SSLType = RoboHelp.SSLLayoutType.WEBHELP;
					break;
				default:
					//Not a supported output type. Do nothing
			}
		}
	}
	
	switch(SSLType) {
		case RoboHelp.SSLLayoutType.WEBHELP:
			goCreateSitemap(doSSL, RoboHelp.SSLLayoutType.WEBHELP);
			break;
		case RoboHelp.SSLLayoutType.MULTISCREENHTML5:
		case RoboHelp.SSLLayoutType.RESPONSIVEHTML:
			goCreateSitemap(doSSL, RoboHelp.SSLLayoutType.MULTISCREENHTML5);
			break;
		default:
			alertUser = false;
	}
	if(alertUser) { 
		alert('Sitemap created.');
	}
}
function goCreateSitemap(doSSL, type) {
	
	//Clear array if it is filled by previous generation.
	sitemapentries = new Array();

	var location = new Folder(ssl_outputDir(doSSL));
	if(type == RoboHelp.SSLLayoutType.WEBHELP) {
		getWebHelpFilesRecursive(location, location);
	} else if(type == RoboHelp.SSLLayoutType.MULTISCREENHTML5) {
		getHTML5FilesRecursive(location, location);
	}
	var url = loadSetting(urlSettingPrefix+doSSL.name);
	var freq = loadSetting(changeFrequencySettingPrefix+doSSL.name);
	
	if(url == "") {
		return false;
	}
	
	var sitemapstring = '<?xml version="1.0" encoding="UTF-8"?>'+"\n"+
						'<urlset xmlns="http://www.sitemaps.org/schemas/sitemap/0.9">';
						
	sitemapstring += getSitemapString(url, freq, "0.5");/* Main URL */
	
	for(var i=0; i<sitemapentries.length;i++) {
		var file = sitemapentries[i];
		sitemapstring += getSitemapString(url+file, freq, getTopicPriority(file));
	}
	sitemapstring+= "\n"+'</urlset>';
	
	var sitemapfile = new File(ssl_outputDir(doSSL) + '/' + sitemapfilename);
	writeFile(sitemapfile, sitemapstring);
	msg('Sitemap created.'+"\n");
}
function getHTML5FilesRecursive(folder, SSLRoot) {
	var relpath = "";
	if(folder.fsName != SSLRoot.fsName) {
		relpath += folder.fsName.substring(SSLRoot.fsName.length)+"/";
	} else {
		relpath = "/";
	}
	
	var files = folder.getFiles("*");
	for(var i = 0; i<files.length; i++) {
		var file = files[i];
		if(isHTML5Topic(file)) {
			var url = relpath+file.displayName;
			    url = url.replace(/\\/g, "/");
				if(url.substring(0,1) == "/") {
					url = url.substring(1, url.length);
				}
			sitemapentries.push(url);
		} else if (!isHTML5ProjectFolder(file)) {
			getHTML5FilesRecursive(file, SSLRoot);
		}
	}
}
function isHTML5ProjectFolder(folder) {
	
	if(!isFolder(folder))
		return true;

	var webhelpfolders = Array("whxdata");
	var is = false;
	for(var i = 0; i<webhelpfolders.length; i++) {
		if(folder.displayName.toLowerCase() == webhelpfolders[i]) {
			is = true;
			break;
		}
	}
	return is;
}
function getWebHelpFilesRecursive(folder, SSLRoot) {
	var relpath = "";
	if(folder.fsName != SSLRoot.fsName) {
		relpath += folder.fsName.substring(SSLRoot.fsName.length)+"/";
	} else {
		relpath = "/";
	}
	
	var files = folder.getFiles("*");
	for(var i = 0; i<files.length; i++) {
		var file = files[i];
		if(isWebHelpTopic(file)) {
			var url = relpath+file.displayName;
			    url = url.replace(/\\/g, "/");
				if(url.substring(0,1) == "/") {
					url = url.substring(1, url.length);
				}
			sitemapentries.push(url);
		} else if (!isWebHelpProjectFolder(file)) {
			getWebHelpFilesRecursive(file, SSLRoot);
		}
	}
}
function isHTML5Topic(file) {
	return isTopic(file, RoboHelp.SSLLayoutType.MULTISCREENHTML5);
}
function isWebHelpTopic(file) {
	return isTopic(file, RoboHelp.SSLLayoutType.WEBHELP);
}
function isTopic(file, type) {
	var isTopic = true;
	if(type == RoboHelp.SSLLayoutType.WEBHELP) {
		if(in_array(filename(file.fsName), WebHelpFiles)) {
			isTopic = false;
		}
	} else if(type == RoboHelp.SSLLayoutType.MULTISCREENHTML5) {
		if(in_array(filename(file.fsName), HTML5Files)) {
			isTopic = false;
		}
	}
	
	if(isTopic === true) {
		if(!in_array(extension(file.fsName), new Array('.htm', '.html', '.doc', '.docx', '.xls', '.xlsx', '.pdf', '.rtf'))) {
			isTopic = false;
		}
	}
	
	return isTopic;
}
function isWebHelpProjectFolder(folder) {
	
	if(!isFolder(folder))
		return true;

	var webhelpfolders = Array("whdata", "whgdata", "whxdata", "webhelp_skin_files");
	var is = false;
	for(var i = 0; i<webhelpfolders.length; i++) {
		if(folder.displayName.toLowerCase() == webhelpfolders[i]) {
			is = true;
			break;
		}
	}
	return is;
}
function getSitemapString(url, fequency, priority) {
	var string ="\n"+"\t"+'<url>'+"\n"+
				"\t"+"\t"+'<loc>'+url+'</loc>'+"\n"+
				"\t"+"\t"+'<changefreq>'+fequency+'</changefreq>'+"\n"+
				"\t"+"\t"+'<priority>0.5</priority>'+"\n"+
				"\t"+'</url>';
	return string;
}
function getTopicPriority(file) {
	return "0.5";
}
